
# Introduction -------

#This script contains code for running the very slow cluster correction for figure 2, 
#and saving the results which can then be quickly loaded for plotting

#In this script we will focus on doing the cluster-correction for

# - The standard PSD data
# - Z scored signal PSD
# - IRASA oscillatory data
# - IRASA fractal data


#Load packages ----

pacman::p_load(tidyverse, patchwork, ghibli,eegUtils,
               emmeans,lme4,broom.mixed,tidybayes,boot)


#Get our default settings
source("./eLife Submission Scripts/Analysis-Common-Utilities.R")


# Default Settings ======

#Set frequencies we will use
fUse = seq(0.5,20,by = 0.5)

# - We need a formula for our stats model
f_in = as.formula(power ~ group + gender + age_eeg + (1|family))

# - We need a grouping variable - this is going to be the electrode of frequency channel
g_var = 'frequency'

# - Set total permutations
t_p = 500

# - Set the cluster alpha
c_a = 0.025

# Set the montecarlo alpha
m_a = 0.05


# Load up ======

# Lets do all of our preparation in one go here

#Load PSD dataset
d = readr::read_rds("./eLife Submission Data/sleep_study_psd_data.rds")



# Make bootstrap CIs ======

#Get the bootstrap CIs
d_psd = 
  d |>
  group_by(frequency,stage,group,dataset) |>
  nest()  |>
  mutate(dataset = factor(dataset,levels = c("welch","welch_z","logo","frac"))) |>
  mutate(mu      = map_dbl(data,mu_function2),
         boot_t  = map(data,~boot(data = .x, statistic = mu_function2, R = 1000))) |>
  mutate(boot_ci = map(boot_t,boot.ci, conf = 0.95, type = "bca" )) |>
  mutate(ci      = map(boot_ci, ~.x$bca %>% as_tibble() |> select(V4,V5) |> rename(ci.low = V4, ci.high = V5))) 



# Do the cluster correction =============

# Prepare for the cluster correction
d = 
  d |>
  left_join(meta |> select(subject,family, gender, age_eeg), by = "subject") |>
  mutate(group = factor(group,levels = c("Sib","22q"))) |>
  group_by(stage,dataset) |>
  nest()  


#Get neighbours data
fList = 
  d_welch |>
  distinct(frequency) |>
  pull(frequency) 

fList = fList*1e4 |> as.integer()

fStep = 
  diff(fList,1) |> 
  round(digits = 1) |> 
  unique()

fStep = fStep |> as.integer()

d_f_neighbours =
  d_welch |>
  distinct(frequency)|>
  mutate(frequency = as.integer(frequency*1e4)) |>
  mutate(data = map(frequency, ~c(.x - fStep,.x + fStep))) |>
  mutate(data = map(data, ~.x[.x %in% fList])) |>
  mutate(frequency = frequency/1e4,
         data  = map(data,~.x/1e4))


#Now do the grouped cluster correction - note this step takes a long time to compute
d = d |>
  mutate(clusters = map(data,cluster_correct,
                        neighbours = d_f_neighbours,
                        group_var = g_var,
                        totperm = t_p,clus_alpha = c_a, montecarlo_alpha = m_a, 
                        formula_in = f_in))


# Save ----- 
write_rds(d_psd,"./eLife Submission Data/sleep_study_psd_bootci.rds")
write_rds(d    ,"./eLife Submission Data/sleep_study_psd_clusters.rds")
